/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpdmgr;

import com.ibm.hwmca.base.vpdmgr.VpdConfigurationData;
import com.ibm.hwmca.base.vpdmgr.VpdDeviceData;
import com.ibm.hwmca.base.vpdmgr.VpdFileRecord;
import com.ibm.hwmca.base.vpdmgr.VpdFruData;
import com.ibm.hwmca.base.vpdmgr.VpdInputData;
import com.ibm.hwmca.base.vpdmgr.VpdProfileData;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.base.vpdmgr.VpdUnitData;
import com.ibm.hwmca.base.vpdmgr.VpdcFileAccess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VpdData {
    private static final String TRACE_MASKT = "XVPDDATT";
    private static final String TRACE_MASKF = "XVPDDATF";
    private static final String TRACE_MASKD = "XVPDDATD";
    public static final int XVPD_NOT_FOUND = 1;
    public static final int XVPD_INVALID_COMMAND = 16;
    public static final int XVPD_INVALID_LOCATION = 17;
    public static final int XVPD_INVALID_PN = 18;
    public static final int XVPD_INVALID_CCIN = 19;
    public static final int XVPD_SAME_DATA = 20;
    public static final int XVPD_NO_NEW_LOCATION = 21;
    public static final int XVPD_MOVE_LENGTH_ERROR = 22;
    public static final int XVPD_NO_UNIT_DATA = 23;
    public static final int XVPD_NO_NEW_DATA = 32;
    private int vpdCommand;
    private int rc;
    private VpdInputData inputData;
    private VpdFruData fruNewData;
    private VpdFruData fruExistData;
    private VpdDeviceData deviceNewData;
    private VpdDeviceData deviceExistData;
    private VpdConfigurationData machineNewData;
    private VpdConfigurationData machineExistData;
    private VpdProfileData profileNewData;
    private VpdProfileData profileExistData;
    private VpdUnitData unitNewData;
    private VpdUnitData unitExistData;
    protected VpdFileRecord[] searchArray;

    public VpdData() {
        this.fruNewData = new VpdFruData();
        this.fruExistData = new VpdFruData();
        this.machineNewData = new VpdConfigurationData();
        this.machineExistData = new VpdConfigurationData();
        this.inputData = new VpdInputData();
        this.deviceNewData = new VpdDeviceData();
        this.deviceExistData = new VpdDeviceData();
        this.profileNewData = new VpdProfileData();
        this.profileExistData = new VpdProfileData();
        this.unitNewData = new VpdUnitData();
        this.unitExistData = new VpdUnitData();
        this.rc = 0;
    }

    public VpdData(VpdRequestValue vpdCommand) {
        this.setVpdCommand(vpdCommand);
        this.fruNewData = new VpdFruData();
        this.fruExistData = new VpdFruData();
        this.machineNewData = new VpdConfigurationData();
        this.machineExistData = new VpdConfigurationData();
        this.inputData = new VpdInputData();
        this.deviceNewData = new VpdDeviceData();
        this.deviceExistData = new VpdDeviceData();
        this.profileNewData = new VpdProfileData();
        this.profileExistData = new VpdProfileData();
        this.unitNewData = new VpdUnitData();
        this.unitExistData = new VpdUnitData();
        this.rc = 0;
    }

    public int getVpdCommand() {
        return this.vpdCommand;
    }

    public void setVpdCommand(VpdRequestValue command) {
        this.vpdCommand = command.intValue();
    }

    public void setVpdInputData(VpdInputData data) {
        this.inputData = data;
    }

    public void setVpdFruNewData(VpdFruData data) {
        this.fruNewData = data;
    }

    public void setVpdDeviceNewData(VpdDeviceData data) {
        this.deviceNewData = data;
    }

    public void setVpdConfigurationNewData(VpdConfigurationData data) {
        this.machineNewData = data;
    }

    public void setVpdProfileNewData(VpdProfileData data) {
        this.profileNewData = data;
    }

    public void setVpdUnitNewData(VpdUnitData data) {
        this.unitNewData = data;
    }

    protected void setVpdFruExistData(VpdFruData data) {
        this.fruExistData = data;
    }

    protected void setVpdDeviceExistData(VpdDeviceData data) {
        this.deviceExistData = data;
    }

    protected void setVpdConfigurationExistData(VpdConfigurationData data) {
        this.machineExistData = data;
    }

    protected void setVpdProfileExistData(VpdProfileData data) {
        this.profileExistData = data;
    }

    protected void setVpdUnitExistData(VpdUnitData data) {
        this.unitExistData = data;
    }

    public VpdFruData getVpdFruExistData() {
        return this.fruExistData;
    }

    public VpdInputData getVpdInputData() {
        return this.inputData;
    }

    public VpdDeviceData getVpdDeviceExistData() {
        return this.deviceExistData;
    }

    public VpdConfigurationData getVpdConfigurationExistData() {
        return this.machineExistData;
    }

    public VpdProfileData getVpdProfileExistData() {
        return this.profileExistData;
    }

    public VpdUnitData setVpdUnitExistData() {
        return this.unitExistData;
    }

    public VpdFruData getVpdFruNewData() {
        return this.fruNewData;
    }

    public VpdDeviceData getVpdDeviceNewData() {
        return this.deviceNewData;
    }

    public VpdConfigurationData getVpdConfigurationNewData() {
        return this.machineNewData;
    }

    public VpdProfileData getVpdProfileNewData() {
        return this.profileNewData;
    }

    public VpdUnitData getVpdUnitNewData() {
        return this.unitNewData;
    }

    public List getSearchData() {
        ArrayList<VpdFileRecord> searchData = new ArrayList<VpdFileRecord>(this.searchArray.length);
        for (int i = 0; i < this.searchArray.length; ++i) {
            searchData.add(this.searchArray[i]);
        }
        return Collections.unmodifiableList(searchData);
    }

    public List readVpdc(File filename) throws IOException {
        Trace.trace(TRACE_MASKT, "<> VpdData.readVpdc()");
        return VpdcFileAccess.readVpdc(filename);
    }

    public void writeVpdc(File filename, List list) throws IOException {
        Trace.trace(TRACE_MASKT, "-> VpdData.writeVpdc()");
        VpdcFileAccess.writeVpdc(filename, list);
        Trace.trace(TRACE_MASKT, "<- VpdData.writeVpdc()");
    }

    protected VpdFileRecord[] createSearchArray(int count) {
        this.searchArray = new VpdFileRecord[count];
        for (int i = 0; i < this.searchArray.length; ++i) {
            this.searchArray[i] = new VpdFileRecord();
        }
        return this.searchArray;
    }

    protected int getIntRc() {
        return this.rc;
    }
}

